/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.CRC16;
import com.webcodepro.shrinkit.io.BitInputStream;
import com.webcodepro.shrinkit.io.LittleEndianByteInputStream;
import com.webcodepro.shrinkit.io.LzwInputStream;
import com.webcodepro.shrinkit.io.RleInputStream;
import java.io.IOException;
import java.io.InputStream;

public class NufxLzw2InputStream
extends InputStream {
    private LittleEndianByteInputStream dataStream;
    private LzwInputStream lzwStream;
    private RleInputStream rleStream;
    private InputStream lzwRleStream;
    private InputStream decompressionStream;
    private int bytesLeftInChunk;
    private int volumeNumber = -1;
    private int rleCharacter;
    private CRC16 dataCrc = new CRC16();

    public NufxLzw2InputStream(LittleEndianByteInputStream dataStream) {
        this.dataStream = dataStream;
    }

    @Override
    public int read() throws IOException {
        if (this.volumeNumber == -1) {
            this.volumeNumber = this.dataStream.readByte();
            this.rleCharacter = this.dataStream.readByte();
            this.lzwStream = new LzwInputStream(new BitInputStream(this.dataStream, 9));
            this.rleStream = new RleInputStream(this.dataStream, this.rleCharacter);
            this.lzwRleStream = new RleInputStream(this.lzwStream);
        }
        if (this.bytesLeftInChunk == 0) {
            this.bytesLeftInChunk = 4096;
            this.lzwStream.clearData();
            int word = this.dataStream.readWord();
            int length = word & Short.MAX_VALUE;
            int lzwFlag = word & 0x8000;
            if (lzwFlag == 0) {
                this.lzwStream.clearDictionary();
            } else {
                this.dataStream.readWord();
            }
            int flag = (lzwFlag == 0 ? 0 : 1) + (length == 4096 ? 0 : 2);
            switch (flag) {
                case 0: {
                    this.decompressionStream = this.dataStream;
                    break;
                }
                case 1: {
                    this.decompressionStream = this.lzwStream;
                    break;
                }
                case 2: {
                    this.decompressionStream = this.rleStream;
                    break;
                }
                case 3: {
                    this.decompressionStream = this.lzwRleStream;
                    break;
                }
                default: {
                    throw new IOException("Unknown type of decompression, flag = " + flag);
                }
            }
        }
        int b = this.decompressionStream.read();
        --this.bytesLeftInChunk;
        this.dataCrc.update(b);
        return b;
    }

    public int getVolumeNumber() {
        return this.volumeNumber;
    }

    public void setVolumeNumber(int volumeNumber) {
        this.volumeNumber = volumeNumber;
    }

    public int getRleCharacter() {
        return this.rleCharacter;
    }

    public void setRleCharacter(int rleCharacter) {
        this.rleCharacter = rleCharacter;
    }

    public long getDataCrc() {
        return this.dataCrc.getValue();
    }
}

